define([
    'backbone',
    'Layout',
    'modules/feedback/feedback-view',
],
function(
    Backbone,
    Layout,
    FeedBackView
) {
    'use strict';
    describe('FeedBack View', function() {
        var view;
        var $view;
        var layout = new Layout();
        beforeEach(function () {
            spyOn(FeedBackView.prototype, 'onRender').and.callThrough();
            layout.render();
            view = new FeedBackView();
            layout.showChildView('content', view);
            $view = view.$el;
        });
        afterEach(function () {
            layout.getRegion('content').empty();
        });

        describe('when the view renders', function() {
            it('should disable the submit button', function() {
                expect($view.find('#submit-feedback').prop('disabled')).toBe(true);
            });
        });
 
        describe('when feedback is updated', function() {
            it('has a submit button that remains disabled if the value is empty', function() {
                var e = {
                    target: {
                        value: '',
                        name: 'recommendationRating',
                    },
                };
                view.feedbackModel.set('recommendationRating', 5);
                view.handlefeedBackChange(e);
                expect(view.feedbackModel.get('recommendationRating')).toEqual('');
                expect(view.ui.select[0].value).toEqual('');
                expect($view.find('#submit-feedback').prop('disabled')).toBe(true);
            });

            it('can update model when button changes', function() {
                var e = {
                    target: {
                        value: 1,
                        name: 'recommendationRating',
                    },
                };
                view.handlefeedBackChange(e);
                expect(view.feedbackModel.get('recommendationRating')).toEqual(1);
                expect(view.ui.radio[1].checked).toBe(true);
                expect(view.ui.select[0].value).toEqual('1');
                expect($view.find('#submit-feedback').prop('disabled')).toBe(false);
            });
        
            it('can update model when comments are changed', function() {
                var e = {
                    target: {
                        value: 'taco master',
                        name: 'comments',
                    },
                };
                view.handlefeedBackChange(e);
                expect(view.feedbackModel.get('comments')).toEqual('taco master');
                expect($view.find('#submit-feedback').prop('disabled')).toBe(true);
            });
        });
    });
});
